<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">

<h3 class="mb-4" style="color: white;">🎓 Riwayat Pendidikan</h3>

    <!-- 🔍 SEARCH + FILTER -->
    <div class="row mb-3">
        <div class="col-md-8">
            <form method="get" class="row g-2">
                <div class="col-md-5">
                    <input type="text"
                        name="keyword"
                        class="form-control"
                        placeholder="Cari sekolah / jurusan"
                        value="<?= esc($_GET['keyword'] ?? '') ?>">
                </div>

                <div class="col-md-3">
                    <select name="jenjang" class="form-select">
                        <option value="">Semua Jenjang</option>
                        <?php
                        $listJenjang = ['SD', 'SMP', 'SMA', 'Kuliah'];
                        foreach ($listJenjang as $j) :
                        ?>
                            <option value="<?= $j ?>"
                                <?= ($_GET['jenjang'] ?? '') == $j ? 'selected' : '' ?>>
                                <?= $j ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <div class="col-md-2">
                    <button class="btn btn-primary w-100">Cari</button>
                </div>
            </form>
        </div>

        <div class="col-md-4 text-end">
            <a href="/auth/pendidikan/create" class="btn btn-success">
                ➕ Tambah Pendidikan
            </a>
        </div>
    </div>

    <!-- 📋 TABLE -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark text-center">
                <tr>
                    <th width="80">Logo</th>
                    <th>
                        <a href="?sort=jenjang&order=asc"
                            class="text-white text-decoration-none">
                            Jenjang ⬍
                        </a>
                    </th>
                    <th>
                        <a href="?sort=nama_sekolah&order=asc"
                            class="text-white text-decoration-none">
                            Nama Sekolah ⬍
                        </a>
                    </th>
                    <th>Jurusan</th>
                    <th>
                        <a href="?sort=tahun_masuk&order=desc"
                            class="text-white text-decoration-none">
                            Tahun Masuk ⬍
                        </a>
                    </th>
                    <th>Tahun Lulus</th>
                    <th width="150">Aksi</th>
                </tr>
            </thead>

            <tbody>
                <?php if (empty($pendidikan)) : ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted">
                            Data pendidikan belum tersedia
                        </td>
                    </tr>
                <?php endif ?>

                <?php foreach ($pendidikan as $p) : ?>
                    <tr>
                        <td class="text-center">
                            <?php if ($p['logo_sekolah']) : ?>
                                <img src="/uploads/pendidikan/<?= esc($p['logo_sekolah']) ?>"
                                    class="img-thumbnail"
                                    style="max-height:60px">
                            <?php else : ?>
                                <span class="text-muted">-</span>
                            <?php endif ?>
                        </td>

                        <td class="text-center"><?= esc($p['jenjang']) ?></td>
                        <td><?= esc($p['nama_sekolah']) ?></td>
                        <td><?= esc($p['jurusan']) ?></td>
                        <td class="text-center"><?= esc($p['tahun_masuk']) ?></td>
                        <td class="text-center"><?= esc($p['tahun_lulus']) ?></td>
                        <td class="text-center">
                            <a href="/auth/pendidikan/edit/<?= $p['id'] ?>"
                                class="btn btn-warning btn-sm">
                                Edit
                            </a>
                            <a href="/auth/pendidikan/delete/<?= $p['id'] ?>"
                                class="btn btn-danger btn-sm"
                                onclick="return confirm('Hapus data ini?')">
                                Hapus
                            </a>
                        </td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    </div>

    <!-- 📄 PAGINATION -->
    <div class="d-flex justify-content-center">
        <?= $pager->links() ?>
    </div>

</div>

<?= $this->include('layout/footer_admin') ?>